<?php

use Dompdf\Dompdf;
use Dompdf\Options;

require 'dompdf/autoload.inc.php';

date_default_timezone_set('Asia/Makassar');

// Ambil parameter dari URL atau form
$name = isset($_GET['name']) ? $_GET['name'] : null;
$type = isset($_GET['type']) ? $_GET['type'] : null;
$from = isset($_GET['from']) ? $_GET['from'] : null;
$to = isset($_GET['to']) ? $_GET['to'] : null;
$no_invoice = isset($_GET['no_invoice']) ? $_GET['no_invoice'] : null;
$status = isset($_GET['status']) ? $_GET['status'] : null;
$product = isset($_GET['product']) ? $_GET['product'] : null;
$vendor = isset($_GET['vendor']) ? $_GET['vendor'] : null;

try {
  $pdo = new PDO('mysql:host=localhost;dbname=tiketxplorer_db', 'tiketxplorer_admin', 'mindi~!@#');
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Inisialisasi query dan parameter
  $query = "SELECT * FROM yuren_balitiket_bookings WHERE vendor_id = :vendor_id";
  $params = [':vendor_id' => $vendor];

    // Tambahkan kondisi query berdasarkan parameter
  if ($name) {
    $query .= " AND name LIKE :name";
    $params[':name'] = '%' . $name . '%';
  }

  if ($type) {
    if ($type == 'Booking Date') {
      if ($from) {
        $query .= " AND invoice_date >= :from";
        $params[':from'] = $from;
      }
      if ($to) {
        $query .= " AND invoice_date <= :to";
        $params[':to'] = $to;
      }
    } elseif ($type == 'Arrival Date') {
      if ($from) {
        $query .= " AND arrival_date >= :from";
        $params[':from'] = $from;
      }
      if ($to) {
        $query .= " AND arrival_date <= :to";
        $params[':to'] = $to;
      }
    }
  } else {
    if ($from) {
      $query .= " AND invoice_date >= :from";
      $params[':from'] = $from;
    }
    if ($to) {
      $query .= " AND invoice_date <= :to";
      $params[':to'] = $to;
    }
  }

  if ($no_invoice) {
    $query .= " AND no_invoice LIKE :no_invoice";
    $params[':no_invoice'] = '%' . $no_invoice . '%';
  }

  if ($status) {
    $query .= " AND status_payment = :status";
    $params[':status'] = $status;
  }

  if ($product) {
    $query .= " AND product_id = :product";
    $params[':product'] = $product;
  }

    // Prepare and execute the query
  $stmt = $pdo->prepare($query);
  $stmt->execute($params);
  $bookings = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Ambil nama tiket
  $query2 = "SELECT * FROM yuren_balitiket_tickets WHERE vendor_id = :vendor_id";
  $params2 = [':vendor_id' => $vendor];
  $stmt2 = $pdo->prepare($query2);
  $stmt2->execute($params2);
  $tickets = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    // Buat array untuk menyimpan nama tiket dengan ID-nya
  $ticketNames = [];
  foreach ($tickets as $ticket) {
    $ticketNames[$ticket['id']] = $ticket['name'];
  }

    // Clone query for total revenue calculation
    $revenueQuery = "SELECT SUM(total_price) as total_revenue, SUM(person) as person FROM yuren_balitiket_bookings WHERE vendor_id = :vendor_id AND status_payment = 'paid'";
    $revenueParams = [':vendor_id' => $vendor];
  
    if ($type) {
      if ($type == 'Booking Date') {
        if ($from) {
          $revenueQuery .= " AND invoice_date >= :from";
          $revenueParams[':from'] = $from;
        }
        if ($to) {
          $revenueQuery .= " AND invoice_date <= :to";
          $revenueParams[':to'] = $to;
        }
      } elseif ($type == 'Arrival Date') {
        if ($from) {
          $revenueQuery .= " AND arrival_date >= :from";
          $revenueParams[':from'] = $from;
        }
        if ($to) {
          $revenueQuery .= " AND arrival_date <= :to";
          $revenueParams[':to'] = $to;
        }
      }
    }
  
    if ($name) {
      $revenueQuery .= " AND name LIKE :name";
      $revenueParams[':name'] = '%' . $name . '%';
    }
  
    if ($no_invoice) {
      $revenueQuery .= " AND no_invoice LIKE :no_invoice";
      $revenueParams[':no_invoice'] = '%' . $no_invoice . '%';
    }
  
    if ($status) {
      $revenueQuery .= " AND status_payment = :status";
      $revenueParams[':status'] = $status;
    }
  
    if ($product) {
      $revenueQuery .= " AND product_id = :product";
      $revenueParams[':product'] = $product;
    }
  
    $stmt3 = $pdo->prepare($revenueQuery);
    $stmt3->execute($revenueParams);
    $totalRevenueResult = $stmt3->fetch(PDO::FETCH_ASSOC);
    $totalRevenue = $totalRevenueResult['total_revenue'];
    $totalPerson = $totalRevenueResult['person'];
    $totalRevenueFormatted = number_format($totalRevenue, 0, ',', '.');

} catch (PDOException $e) {
  die('Database error: ' . $e->getMessage());
}


// Query untuk status booking berdasarkan status pembayaran (pending, paid, expired)
$statusQuery = "SELECT status_payment, COUNT(*) as count, SUM(total_price) as revenue 
                FROM yuren_balitiket_bookings 
                WHERE vendor_id = :vendor_id";

// Tambahkan parameter tanggal berdasarkan $type
if ($type) {
    if ($type == 'Booking Date') {
        if ($from) {
            $statusQuery .= " AND invoice_date >= :from";
            $statusParams[':from'] = $from;
        }
        if ($to) {
            $statusQuery .= " AND invoice_date <= :to";
            $statusParams[':to'] = $to;
        }
    } elseif ($type == 'Arrival Date') {
        if ($from) {
            $statusQuery .= " AND arrival_date >= :from";
            $statusParams[':from'] = $from;
        }
        if ($to) {
            $statusQuery .= " AND arrival_date <= :to";
            $statusParams[':to'] = $to;
        }
    }
}

// Tambahkan filter lainnya
if ($name) {
    $statusQuery .= " AND name LIKE :name";
    $statusParams[':name'] = '%' . $name . '%';
}
if ($no_invoice) {
    $statusQuery .= " AND no_invoice LIKE :no_invoice";
    $statusParams[':no_invoice'] = '%' . $no_invoice . '%';
}
if ($status) {
    $statusQuery .= " AND status_payment = :status";
    $statusParams[':status'] = $status;
}
if ($product) {
    $statusQuery .= " AND product_id = :product";
    $statusParams[':product'] = $product;
}

$statusQuery .= " GROUP BY status_payment ORDER BY FIELD(status_payment, 'paid', 'pending', 'expired')"; // Urutkan sesuai status

$statusParams[':vendor_id'] = $vendor;

$stmt6 = $pdo->prepare($statusQuery);
$stmt6->execute($statusParams);
$statusBookings = $stmt6->fetchAll(PDO::FETCH_ASSOC);
// end status pembayaran query

// countries query
$countriesQuery = "SELECT country, SUM(person) as amount, SUM(total_price) as revenue 
                   FROM yuren_balitiket_bookings 
                   WHERE vendor_id = :vendor_id 
                   AND status_payment = 'paid'";

// Tambahkan parameter tanggal berdasarkan $type
if ($type) {
  if ($type == 'Booking Date') {
      if ($from) {
          $countriesQuery .= " AND invoice_date >= :from";
          $countriesParams[':from'] = $from;
      }
      if ($to) {
          $countriesQuery .= " AND invoice_date <= :to";
          $countriesParams[':to'] = $to;
      }
  } elseif ($type == 'Arrival Date') {
      if ($from) {
          $countriesQuery .= " AND arrival_date >= :from";
          $countriesParams[':from'] = $from;
      }
      if ($to) {
          $countriesQuery .= " AND arrival_date <= :to";
          $countriesParams[':to'] = $to;
      }
  }
}

// Tambahkan filter lainnya
if ($name) {
    $countriesQuery .= " AND name LIKE :name";
    $countriesParams[':name'] = '%' . $name . '%';
}
if ($no_invoice) {
    $countriesQuery .= " AND no_invoice LIKE :no_invoice";
    $countriesParams[':no_invoice'] = '%' . $no_invoice . '%';
}
if ($status) {
    $countriesQuery .= " AND status_payment = :status";
    $countriesParams[':status'] = $status;
}
if ($product) {
    $countriesQuery .= " AND product_id = :product";
    $countriesParams[':product'] = $product;
}

// Tambahkan pengelompokan, pengurutan, dan pembatasan jumlah hasil
$countriesQuery .= " GROUP BY country ORDER BY revenue DESC LIMIT 5";

$countriesParams[':vendor_id'] = $vendor;

$stmt4 = $pdo->prepare($countriesQuery);
$stmt4->execute($countriesParams);
$countries = $stmt4->fetchAll(PDO::FETCH_ASSOC);
// end countries query


// best selling query
$bestsellingQuery = "SELECT ticket_id, SUM(person) as amount, SUM(total_price) as revenue 
                     FROM yuren_balitiket_bookings 
                     WHERE vendor_id = :vendor_id 
                     AND status_payment = 'paid'";

// Tambahkan parameter tanggal
$bestsellingParams = [':vendor_id' => $vendor];

if ($type) {
  if ($type == 'Booking Date') {
      if ($from) {
          $bestsellingQuery .= " AND invoice_date >= :from";
          $bestsellingParams[':from'] = $from;
      }
      if ($to) {
          $bestsellingQuery .= " AND invoice_date <= :to";
          $bestsellingParams[':to'] = $to;
      }
  } elseif ($type == 'Arrival Date') {
      if ($from) {
          $bestsellingQuery .= " AND arrival_date >= :from";
          $bestsellingParams[':from'] = $from;
      }
      if ($to) {
          $bestsellingQuery .= " AND arrival_date <= :to";
          $bestsellingParams[':to'] = $to;
      }
  }
}

// Tambahkan filter lainnya
if ($name) {
    $bestsellingQuery .= " AND name LIKE :name";
    $bestsellingParams[':name'] = '%' . $name . '%';
}
if ($no_invoice) {
    $bestsellingQuery .= " AND no_invoice LIKE :no_invoice";
    $bestsellingParams[':no_invoice'] = '%' . $no_invoice . '%';
}
if ($status) {
    $bestsellingQuery .= " AND status_payment = :status";
    $bestsellingParams[':status'] = $status;
}
if ($product) {
    $bestsellingQuery .= " AND product_id = :product";
    $bestsellingParams[':product'] = $product;
}

// Tambahkan pengelompokan, pengurutan, dan pembatasan jumlah hasil
$bestsellingQuery .= " GROUP BY ticket_id ORDER BY revenue DESC LIMIT 5";

$stmt5 = $pdo->prepare($bestsellingQuery);
$stmt5->execute($bestsellingParams);
$bestselling = $stmt5->fetchAll(PDO::FETCH_ASSOC);
// end best selling query

// Generate HTML for PDF
$date_created = '';
if ($from != null) {
  $date_created .= 'Date : ' . htmlspecialchars($from);
}
if ($to != null) {
  $date_created .= ' - ' . htmlspecialchars($to);
} elseif ($from != null) {
  $date_created .= ' - ' . date('Y-m-d');
}

$html = '<html>
<head>
<title>Booking List</title>
<style>
*{
  font-family: Arial, Helvetica, sans-serif;
}
table {
  width: 100%;
  border-collapse: collapse;
}
table, th, td {
  border: 1px solid black;
}
th, td {
  padding: 8px;
  text-align: left;
}
</style>
</head>
<body>
<h1>Booking List</h1>
<p align="right">' . $date_created . '</p>
<table>
<thead style="background-color:#9EC3E8">
<tr>
<th><small>No. Invoice</small></th>
<th><small>Booking Date</small></th>
<th><small>Name</small></th>
<th><small>Arrival Date</small></th>
<th><small>Ticket</small></th>
<th><small>Person</small></th>
<th><small>Amount</small></th>
<th><small>Status</small></th>
</tr>
</thead>
<tbody>';

foreach ($bookings as $booking) {
  $ticketName = isset($ticketNames[$booking['ticket_id']]) ? htmlspecialchars($ticketNames[$booking['ticket_id']]) : 'Unknown';

  $statusPayment = '';
  if ($booking['status_payment'] == 'paid'){
    $statusPayment = '<td style="text-align: center; background-color: #9CE38E"><small>' . htmlspecialchars($booking['status_payment']) . '</small></td>';
  } elseif ($booking['status_payment'] == 'pending'){
    $statusPayment = '<td style="text-align: center; background-color: #EFD69B"><small>' . htmlspecialchars($booking['status_payment']) . '</small></td>';
  } elseif ($booking['status_payment'] == 'expired'){
    $statusPayment = '<td style="text-align: center; background-color: #EF9898"><small>' . htmlspecialchars($booking['status_payment']) . '</small></td>';
  } 


  $html .= '<tr>
  <td><small>' . htmlspecialchars($booking['no_invoice']) . '</small></td>
  <td style="text-align: center"><small>' . htmlspecialchars($booking['invoice_date']) . '</small></td>
  <td><small>' . htmlspecialchars($booking['firstname']) . '</small></td>
  <td style="text-align: center"><small>' . htmlspecialchars($booking['arrival_date']) . '</small></td>
  <td><small>' . $ticketName . '</small></td>
  <td style="text-align: center"><small>' . htmlspecialchars($booking['person']) . '</small></td>
  <td><small>IDR ' . htmlspecialchars(number_format($booking['total_price'], 0, ',', '.')) . '</small></td>
  '.$statusPayment.'
  </tr>';
}

$html .= '</tbody>
</table>

<table style="width: 30%; margin-top: 20px; margin-left: auto">
<tbody>
<tr>
<td style="border:none; width: 40%">Total Revenue</td>
<td style="border:none; width: 3%">:</td>
<td style="border:none; width: 57%"><b>IDR ' . $totalRevenueFormatted . '</b></td>
</tr>
</tbody>
</table>

<div>';


foreach ($statusBookings as $statusBooking) {
  $html .= '<p style="margin-bottom:5px">Booking ' . htmlspecialchars($statusBooking['status_payment']) . ' : <b>' . htmlspecialchars($statusBooking['count']) . '</b></p>';
}


$html .= '</div>
<section>
<table style="width:100%; margin-top: 20px; border:none">
<tr>
<td style="border:none; width: 50%; padding-right:20px; vertical-align:top">
<h3>Booking List by Country</h3>
<table>
<thead style="background-color:#9EC3E8">
<tr>
<th>Country</th>
<th style="text-align:center">Amount</th>
<th style="text-align: center">Revenue</th>
</tr>
</thead>
<tbody>';

foreach ($countries as $country) {
  $html .= '<tr>
  <td>' . htmlspecialchars($country['country']) . '</td>
  <td style="text-align: center">' . htmlspecialchars($country['amount']) . '</td>
  <td style="text-align: center">IDR ' . number_format($country['revenue'], 0, ',', '.') . '</td>
  </tr>';
}

$html .= '</tbody>
</table>
</td>
<td style="border:none; width: 50%; padding-left:20px; vertical-align:top">
<h3>Booking List by Ticket</h3>
<table>
<thead style="background-color:#9EC3E8">
<tr>
<th>Ticket</th>
<th style="text-align:center">Amount</th>
<th style="text-align: center">Revenue</th>
</tr>
</thead>
<tbody>';

foreach ($bestselling as $best) {
  $ticketName = isset($ticketNames[$best['ticket_id']]) ? htmlspecialchars($ticketNames[$best['ticket_id']]) : 'Unknown';

  $html .= '<tr>
  <td>' . $ticketName . '</td>
  <td style="text-align: center">' . htmlspecialchars($best['amount']) . '</td>
  <td style="text-align: center">IDR ' . number_format($best['revenue'], 0, ',', '.') . '</td>
  </tr>';
}

$html .= '</tbody>
</table>
</td>
</tr>
</table>
</section>

</body>
</html>';

// Initialize Dompdf and load HTML
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// (Optional) Set paper size and orientation
$dompdf->setPaper('A4', 'landscape');

// Render HTML to PDF
$dompdf->render();

// Send PDF as response download
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="bookings.pdf"');
echo $dompdf->output();
exit;
?>