<?php
// Sertakan file XlsxWriter
require 'XlsxWriter/xlsxwriter.class.php';

date_default_timezone_set('Asia/Makassar');

// Ambil parameter dari URL atau form
$name = isset($_GET['name']) ? $_GET['name'] : null;
$type = isset($_GET['type']) ? $_GET['type'] : null;
$from = isset($_GET['from']) ? $_GET['from'] : null;
$to = isset($_GET['to']) ? $_GET['to'] : null;
$no_invoice = isset($_GET['no_invoice']) ? $_GET['no_invoice'] : null;
$status = isset($_GET['status']) ? $_GET['status'] : null;
$product = isset($_GET['product']) ? $_GET['product'] : null;
$vendor = isset($_GET['vendor']) ? $_GET['vendor'] : null;

try {
    $pdo = new PDO('mysql:host=localhost;dbname=tiketxplorer_db', 'tiketxplorer_admin', 'mindi~!@#');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  
      // Inisialisasi query dan parameter
    $query = "SELECT * FROM yuren_balitiket_bookings WHERE vendor_id = :vendor_id";
    $params = [':vendor_id' => $vendor];
  
      // Tambahkan kondisi query berdasarkan parameter
    if ($name) {
      $query .= " AND name LIKE :name";
      $params[':name'] = '%' . $name . '%';
    }
  
    if ($type) {
      if ($type == 'Booking Date') {
        if ($from) {
          $query .= " AND invoice_date >= :from";
          $params[':from'] = $from;
        }
        if ($to) {
          $query .= " AND invoice_date <= :to";
          $params[':to'] = $to;
        }
      } elseif ($type == 'Arrival Date') {
        if ($from) {
          $query .= " AND arrival_date >= :from";
          $params[':from'] = $from;
        }
        if ($to) {
          $query .= " AND arrival_date <= :to";
          $params[':to'] = $to;
        }
      }
    } else {
      if ($from) {
        $query .= " AND invoice_date >= :from";
        $params[':from'] = $from;
      }
      if ($to) {
        $query .= " AND invoice_date <= :to";
        $params[':to'] = $to;
      }
    }
  
    if ($no_invoice) {
      $query .= " AND no_invoice LIKE :no_invoice";
      $params[':no_invoice'] = '%' . $no_invoice . '%';
    }
  
    if ($status) {
      $query .= " AND status_payment = :status";
      $params[':status'] = $status;
    }
  
    if ($product) {
      $query .= " AND product_id = :product";
      $params[':product'] = $product;
    }
  
      // Prepare and execute the query
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    $bookings = $stmt->fetchAll(PDO::FETCH_ASSOC);
  
      // Ambil nama tiket
    $query2 = "SELECT * FROM yuren_balitiket_tickets WHERE vendor_id = :vendor_id";
    $params2 = [':vendor_id' => $vendor];
    $stmt2 = $pdo->prepare($query2);
    $stmt2->execute($params2);
    $tickets = $stmt2->fetchAll(PDO::FETCH_ASSOC);
  
      // Buat array untuk menyimpan nama tiket dengan ID-nya
    $ticketNames = [];
    foreach ($tickets as $ticket) {
      $ticketNames[$ticket['id']] = $ticket['name'];
    }
  
      // Clone query for total revenue calculation
      $revenueQuery = "SELECT SUM(total_price) as total_revenue, SUM(person) as person FROM yuren_balitiket_bookings WHERE vendor_id = :vendor_id AND status_payment = 'paid'";
      $revenueParams = [':vendor_id' => $vendor];
    
      if ($type) {
        if ($type == 'Booking Date') {
          if ($from) {
            $revenueQuery .= " AND invoice_date >= :from";
            $revenueParams[':from'] = $from;
          }
          if ($to) {
            $revenueQuery .= " AND invoice_date <= :to";
            $revenueParams[':to'] = $to;
          }
        } elseif ($type == 'Arrival Date') {
          if ($from) {
            $revenueQuery .= " AND arrival_date >= :from";
            $revenueParams[':from'] = $from;
          }
          if ($to) {
            $revenueQuery .= " AND arrival_date <= :to";
            $revenueParams[':to'] = $to;
          }
        }
      }
    
      if ($name) {
        $revenueQuery .= " AND name LIKE :name";
        $revenueParams[':name'] = '%' . $name . '%';
      }
    
      if ($no_invoice) {
        $revenueQuery .= " AND no_invoice LIKE :no_invoice";
        $revenueParams[':no_invoice'] = '%' . $no_invoice . '%';
      }
    
      if ($status) {
        $revenueQuery .= " AND status_payment = :status";
        $revenueParams[':status'] = $status;
      }
    
      if ($product) {
        $revenueQuery .= " AND product_id = :product";
        $revenueParams[':product'] = $product;
      }
    
      $stmt3 = $pdo->prepare($revenueQuery);
      $stmt3->execute($revenueParams);
      $totalRevenueResult = $stmt3->fetch(PDO::FETCH_ASSOC);
      $totalRevenue = $totalRevenueResult['total_revenue'];
      $totalPerson = $totalRevenueResult['person'];
      $totalRevenueFormatted = number_format($totalRevenue, 0, ',', '.');
  
  } catch (PDOException $e) {
    die('Database error: ' . $e->getMessage());
  }
  
  
  // Query untuk status booking berdasarkan status pembayaran (pending, paid, expired)
  $statusQuery = "SELECT status_payment, COUNT(*) as count, SUM(total_price) as revenue 
                  FROM yuren_balitiket_bookings 
                  WHERE vendor_id = :vendor_id";
  
  // Tambahkan parameter tanggal berdasarkan $type
  if ($type) {
      if ($type == 'Booking Date') {
          if ($from) {
              $statusQuery .= " AND invoice_date >= :from";
              $statusParams[':from'] = $from;
          }
          if ($to) {
              $statusQuery .= " AND invoice_date <= :to";
              $statusParams[':to'] = $to;
          }
      } elseif ($type == 'Arrival Date') {
          if ($from) {
              $statusQuery .= " AND arrival_date >= :from";
              $statusParams[':from'] = $from;
          }
          if ($to) {
              $statusQuery .= " AND arrival_date <= :to";
              $statusParams[':to'] = $to;
          }
      }
  }
  
  // Tambahkan filter lainnya
  if ($name) {
      $statusQuery .= " AND name LIKE :name";
      $statusParams[':name'] = '%' . $name . '%';
  }
  if ($no_invoice) {
      $statusQuery .= " AND no_invoice LIKE :no_invoice";
      $statusParams[':no_invoice'] = '%' . $no_invoice . '%';
  }
  if ($status) {
      $statusQuery .= " AND status_payment = :status";
      $statusParams[':status'] = $status;
  }
  if ($product) {
      $statusQuery .= " AND product_id = :product";
      $statusParams[':product'] = $product;
  }
  
  $statusQuery .= " GROUP BY status_payment ORDER BY FIELD(status_payment, 'paid', 'pending', 'expired')"; // Urutkan sesuai status
  
  $statusParams[':vendor_id'] = $vendor;
  
  $stmt6 = $pdo->prepare($statusQuery);
  $stmt6->execute($statusParams);
  $statusBookings = $stmt6->fetchAll(PDO::FETCH_ASSOC);
  // end status pembayaran query
  
  // countries query
  $countriesQuery = "SELECT country, SUM(person) as amount, SUM(total_price) as revenue 
                     FROM yuren_balitiket_bookings 
                     WHERE vendor_id = :vendor_id 
                     AND status_payment = 'paid'";
  
  // Tambahkan parameter tanggal berdasarkan $type
  if ($type) {
    if ($type == 'Booking Date') {
        if ($from) {
            $countriesQuery .= " AND invoice_date >= :from";
            $countriesParams[':from'] = $from;
        }
        if ($to) {
            $countriesQuery .= " AND invoice_date <= :to";
            $countriesParams[':to'] = $to;
        }
    } elseif ($type == 'Arrival Date') {
        if ($from) {
            $countriesQuery .= " AND arrival_date >= :from";
            $countriesParams[':from'] = $from;
        }
        if ($to) {
            $countriesQuery .= " AND arrival_date <= :to";
            $countriesParams[':to'] = $to;
        }
    }
  }
  
  // Tambahkan filter lainnya
  if ($name) {
      $countriesQuery .= " AND name LIKE :name";
      $countriesParams[':name'] = '%' . $name . '%';
  }
  if ($no_invoice) {
      $countriesQuery .= " AND no_invoice LIKE :no_invoice";
      $countriesParams[':no_invoice'] = '%' . $no_invoice . '%';
  }
  if ($status) {
      $countriesQuery .= " AND status_payment = :status";
      $countriesParams[':status'] = $status;
  }
  if ($product) {
      $countriesQuery .= " AND product_id = :product";
      $countriesParams[':product'] = $product;
  }
  
  // Tambahkan pengelompokan, pengurutan, dan pembatasan jumlah hasil
  $countriesQuery .= " GROUP BY country ORDER BY revenue DESC LIMIT 5";
  
  $countriesParams[':vendor_id'] = $vendor;
  
  $stmt4 = $pdo->prepare($countriesQuery);
  $stmt4->execute($countriesParams);
  $countries = $stmt4->fetchAll(PDO::FETCH_ASSOC);
  // end countries query
  
  
  // best selling query
  $bestsellingQuery = "SELECT ticket_id, SUM(person) as amount, SUM(total_price) as revenue 
                       FROM yuren_balitiket_bookings 
                       WHERE vendor_id = :vendor_id 
                       AND status_payment = 'paid'";
  
  // Tambahkan parameter tanggal
  $bestsellingParams = [':vendor_id' => $vendor];
  
  if ($type) {
    if ($type == 'Booking Date') {
        if ($from) {
            $bestsellingQuery .= " AND invoice_date >= :from";
            $bestsellingParams[':from'] = $from;
        }
        if ($to) {
            $bestsellingQuery .= " AND invoice_date <= :to";
            $bestsellingParams[':to'] = $to;
        }
    } elseif ($type == 'Arrival Date') {
        if ($from) {
            $bestsellingQuery .= " AND arrival_date >= :from";
            $bestsellingParams[':from'] = $from;
        }
        if ($to) {
            $bestsellingQuery .= " AND arrival_date <= :to";
            $bestsellingParams[':to'] = $to;
        }
    }
  }
  
  // Tambahkan filter lainnya
  if ($name) {
      $bestsellingQuery .= " AND name LIKE :name";
      $bestsellingParams[':name'] = '%' . $name . '%';
  }
  if ($no_invoice) {
      $bestsellingQuery .= " AND no_invoice LIKE :no_invoice";
      $bestsellingParams[':no_invoice'] = '%' . $no_invoice . '%';
  }
  if ($status) {
      $bestsellingQuery .= " AND status_payment = :status";
      $bestsellingParams[':status'] = $status;
  }
  if ($product) {
      $bestsellingQuery .= " AND product_id = :product";
      $bestsellingParams[':product'] = $product;
  }
  
  // Tambahkan pengelompokan, pengurutan, dan pembatasan jumlah hasil
  $bestsellingQuery .= " GROUP BY ticket_id ORDER BY revenue DESC LIMIT 5";
  
  $stmt5 = $pdo->prepare($bestsellingQuery);
  $stmt5->execute($bestsellingParams);
  $bestselling = $stmt5->fetchAll(PDO::FETCH_ASSOC);
  // end best selling query

// Generate Excel file
// Initialize XlsxWriter
$writer = new XlsxWriter();

$writer->writeSheetRow('Report Booking', ['List Booking'], ['font-style' => 'bold']);

// Set the title for the export
$writer->writeSheetHeader('Report Booking', [
    'No. Invoice' => 'string',
    'Booking Date' => 'string',
    'Name' => 'string',
    'Arrival Date' => 'string',
    'Ticket' => 'string',
    'Person' => 'integer',
    'Amount' => 'string',
    'Status' => 'string'
], [
    'font-style' => 'bold',
    'fill' => '#A5C5F5'
]);

// Write the data for bookings
foreach ($bookings as $booking) {
    $ticketName = isset($ticketNames[$booking['ticket_id']]) ? $ticketNames[$booking['ticket_id']] : 'Unknown';
    
    $writer->writeSheetRow('Report Booking', [
        $booking['no_invoice'],
        $booking['invoice_date'],
        $booking['firstname'],
        $booking['arrival_date'],
        $ticketName,
        $booking['person'],
        'IDR ' . number_format($booking['total_price'], 0, ',', '.'),
        $booking['status_payment']
    ]);
}

// Write total revenue
$writer->writeSheetRow('Report Booking', [
    '', '', '', '', '', 
    '', 'Total Revenue : IDR ' . $totalRevenueFormatted
], ['font-style' => 'bold']);

$writer->writeSheetRow('Report Booking', ['', '', '', '', '', '', '', '', '']);

foreach ($statusBookings as $status) {
$writer->writeSheetRow('Report Booking', ['Booking '. $status['status_payment'] .' : ', $status['count']]);
}

$writer->writeSheetRow('Report Booking', ['', '', '', '', '', '', '', '', '']);

$writer->writeSheetRow('Report Booking', ['List Booking by Country'], ['font-style' => 'bold']);

// Section for Country Summary
$writer->writeSheetRow('Report Booking', ['Country', 'Amount', 'Revenue'], ['font-style' => 'bold', 'fill' => '#A5C5F5']);
foreach ($countries as $country) {
    $writer->writeSheetRow('Report Booking', [
        $country['country'],
        $country['amount'],
        'IDR ' . number_format($country['revenue'], 0, ',', '.')
    ]);
}

$writer->writeSheetRow('Report Booking', ['', '', '', '', '', '', '', '', '']);

$writer->writeSheetRow('Report Booking', ['List Booking by Ticket'], ['font-style' => 'bold']);

// Section for Best Selling Tickets
$writer->writeSheetRow('Report Booking', ['Ticket', 'Amount', 'Revenue'], ['font-style' => 'bold', 'fill' => '#A5C5F5']);
foreach ($bestselling as $ticket) {
    $ticketName = isset($ticketNames[$ticket['ticket_id']]) ? $ticketNames[$ticket['ticket_id']] : 'Unknown';
    $writer->writeSheetRow('Report Booking', [
        $ticketName,
        $ticket['amount'],
        'IDR ' . number_format($ticket['revenue'], 0, ',', '.')
    ]);
}

// Output the Excel file to the browser
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="bookings_report.xlsx"');
header('Cache-Control: max-age=0');
$writer->writeToStdOut();
exit;

