<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include PHPMailer and Dompdf autoloaders
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

include "phpqrcode/qrlib.php";

date_default_timezone_set('Asia/Makassar');

// Ambil data dari POST
$firstname = $_POST['firstname'];
$lastname = $_POST['lastname'];
$email = $_POST['email'];
$phone = $_POST['phone'];
$country = $_POST['country'];
$terms = $_POST['terms'];

$arrival = $_POST['arrival'];

$ticketid = $_POST['ticket_id']; 
$vendorid = $_POST['vendor_id'];
$guestid = $_POST['guest_id'];
$vendorslug = $_POST['vendor_slug'];

$person = (int)$_POST['person'];

$rateplan = $_POST['rateplan'];
$addon = $_POST['addon'];
$totalprice = $_POST['total_price'];

$bookdate = date('Y-m-d H:i:s');
$status_payment = 'pending';

// API Key Xendit
define('XENDIT_SECRET_KEY', 'xnd_development_hh5qdC8dEwErSISVCSXcpyAZjMFufBbn5L5SuqEjpHVszN6KHizjCNY5Irnjjc');

// Generator kode booking
function generateRandomString($length) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function getAcronym($vendorslug) {
    $words = explode('-', $vendorslug);
    $acronym = '';
    foreach ($words as $word) {
        $acronym .= $word[0];
    }
    return strtoupper($acronym);
}

$acronym = getAcronym($vendorslug);
$prefix = $acronym . '-';
$randomPartLength = 8;
$randomString = generateRandomString($randomPartLength);
$bookcode = $prefix . $randomString;

// Generate QR Code sebanyak person
$storebarcode = "barcode/";
if (!file_exists($storebarcode)) {
    mkdir($storebarcode, 0777, true);
}

for ($i = 0; $i < $person; $i++) {
    $linkbarcode = 'https://main.tiketxplorer.com/check-barcode/' . $bookcode . '?barcode=' . $bookcode . $i;
    $filename = $storebarcode . $bookcode . $i . '.png';
    QRcode::png($linkbarcode, $filename, QR_ECLEVEL_M, 2, 8);
}

// Fungsi membuat invoice
function createInvoice($external_id, $amount, $payer_email) {
    $data = [
        'external_id' => $external_id,
        'amount' => $amount,
        'payer_email' => $payer_email,
        'description' => 'Invoice for Booking ' . $external_id
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api.xendit.co/v2/invoices',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Basic ' . base64_encode(XENDIT_SECRET_KEY . ':')
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    return json_decode($response, true);
}

// Simpan ke database
if ($terms == 'on') {
    $servername = 'localhost';
    $username = 'tiketxplorer_admin';
    $password = 'mindi~!@#';
    $dbname = 'tiketxplorer_db';

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die('Connection failed: ' . $conn->connect_error);
    }

    $sql = 'INSERT INTO yuren_balitiket_bookings (no_invoice, invoice_date, firstname, lastname, email, phone, country, arrival_date, vendor_id, ticket_id, rateplan, person, addon, total_price, status_payment, created_at,guest_id) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        'sssssssssssssssss',
        $bookcode,
        $bookdate,
        $firstname,
        $lastname,
        $email,
        $phone,
        $country,
        $arrival,
        $vendorid,
        $ticketid,
        $rateplan,
        $person,
        $addon,
        $totalprice,
        $status_payment,
        $bookdate,
        $guestid
    );

    if ($stmt->execute()) {
        $sql2 = 'UPDATE yuren_balitiket_tickets SET count_book = count_book + 1 WHERE id = ?';
        $stmt2 = $conn->prepare($sql2);
        $stmt2->bind_param('i', $ticketid);

        if ($stmt2->execute()) {
            $invoice = createInvoice($bookcode, $totalprice, $email);
            if (!empty($invoice['invoice_url'])) {

                $sql3 = "SELECT * FROM yuren_balitiket_tickets WHERE id = '".$ticketid."'";
                $result3 = $conn->query($sql3);
                $ticket = $result3->fetch_assoc();
                
                $link_payment = "https://main.tiketxplorer.com/bali_tiket/payment.php?no_invoice=".$bookcode;

                // Kirim email
                $email_text = 
                '
                <div style="background-color: #0A2A48; padding: 2rem; font-family: sans-serif; font-size:13px">

                <div style="padding: 2rem; background-color: white; width: 750px; margin: 0 auto">

                <p><b>Dear '.$firstname.',</b></p>

                <p style="margin-bottom: 5px;">Thank you for booking with Bali Tiket. We are pleased to inform you that your booking has been received.</p>

                <p style="margin:0 0 8px 0;">Here are the details of your booking:</p>

                <table style="width: 100%; border:1px solid grey; padding: 1rem; font-size: 13px;">
                <tbody>
                <tr>
                <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Name</td>
                <td style="padding-bottom: 8px;width: 75%;">: '.$firstname.'</td>
                </tr>
                <tr>
                <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Phone Number</td>
                <td style="padding-bottom: 8px;width: 75%;">: '.$phone.'</td>
                </tr>
                <tr>
                <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Email</td>
                <td style="padding-bottom: 8px;width: 75%;">: '.$email.'</td>
                </tr>
                <tr>
                <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Ticket</td>
                <td style="padding-bottom: 8px;width: 75%;">: '.$ticket['name'].'</td>
                </tr>
                <tr>
                <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Person</td>
                <td style="padding-bottom: 8px;width: 75%;">: '.$person.' Person</td>
                </tr>
                <tr>
                <td style="width: 25%; font-weight: bold;">Total Price</td>
                <td style="width: 75%;">: IDR '.number_format((int)$totalprice,0,',','.').'</td>
                </tr>
                </tbody>
                </table>

                <p>To complete the booking process, please click the button below to make the payment:</p>

                <p align="center" style="margin: 20px 0;"><a href="'.$link_payment.'" target="_blank" style="background-color: #0A2A48; padding: 7px 30px; border-radius: 3px; color: white; text-decoration: none; font-weight: bold; text-transform: uppercase;">Click Here to Pay</a></p>

                <p>If you have any questions or need further assistance, please feel free to contact us.</p>

                <p>Thank you and have a great day!</p>

                <p style="margin-bottom: 30px;">Best regards,</p>

                <p style="margin-bottom: 5px"><b>Bali Ticket Services</b></p>
                <p style="margin-top: 0px">(+62) 00 0000 0000</p>

                </div>

                </div>
                ';
                try {
                    $mail = new PHPMailer(true);
                    $mail->SMTPDebug = 0;  
                    $mail->Host       = 'mail.mindimedia.com';                 
                    $mail->SMTPAuth   = true;                                
                    $mail->Username   = 'rendi@mindimedia.com';        
                    $mail->Password   = 'RendiMindi2023';                            
                    $mail->SMTPSecure = 'ssl';       
                    $mail->Port       = 465;

                    $mail->setFrom('rendi@mindimedia.com', 'Bali Ticket Services');
                    $mail->addAddress($email);

                    $mail->isHTML(true);
                    $mail->Subject = 'Booking Confirmation - ' . $bookcode;
                    $mail->Body    = $email_text;

                    $mail->send();
                } catch (Exception $e) {
                    // Handle error email
                }

                echo '<script>alert("Booking success! Please complete the payment."); window.location.href = "' . $invoice['invoice_url'] . '";</script>';
            } else {
                echo '<script>alert("Error creating invoice!"); window.history.back();</script>';
            }
        } else {
            echo "<script>alert('Error updating ticket data!');window.history.back();</script>";
        }
    } else {
        echo "<script>alert('Error saving booking data!');window.history.back();</script>";
    }
} else {
    echo "<script>alert('You must agree to the terms & conditions!');window.history.back();</script>";
}
