<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code Generator</title>
    <script src="https://cdn.jsdelivr.net/npm/qrcode-generator/qrcode.min.js"></script>
</head>
<body>
    <h1>QR Code Generator</h1>
    <canvas id="qrCanvas"></canvas>
    <button onclick="generateQRCode()">Generate QR Code</button>

    <script>
        function generateQRCode() {
            var qr = qrcode(0, 'M'); // Create QR code object, 'M' = medium error correction
            qr.addData("https://mindimedia.com"); // Data to encode into QR code
            qr.make(); // Generate QR code
            
            var canvas = document.getElementById('qrCanvas');
            var ctx = canvas.getContext('2d');
            
            var cellSize = 2; // Size of each QR code cell
            var margin = 4; // Margin around QR code
            
            // Adjust canvas size based on QR code size
            canvas.width = qr.getModuleCount() * cellSize + margin * 2;
            canvas.height = qr.getModuleCount() * cellSize + margin * 2;
            
            // Draw QR code on canvas
            for (var row = 0; row < qr.getModuleCount(); row++) {
                for (var col = 0; col < qr.getModuleCount(); col++) {
                    ctx.fillStyle = qr.isDark(row, col) ? '#000' : '#fff';
                    ctx.fillRect(col * cellSize + margin, row * cellSize + margin, cellSize, cellSize);
                }
            }
            
            // Convert canvas to image and save
            var dataURL = canvas.toDataURL("image/png");
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'save_qr_code.php', true); // PHP script to handle saving the QR code
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
            xhr.onload = function() {
                if (xhr.status === 200) {
                    console.log('QR code image saved:', xhr.responseText);
                } else {
                    console.error('Failed to save QR code image.');
                }
            };
            xhr.send('image=' + encodeURIComponent(dataURL));
        }
    </script>
</body>
</html>


<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Dompdf\Dompdf;
use Dompdf\Options;

// Include PHPMailer and Dompdf autoloaders
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'dompdf/autoload.inc.php'; // Adjust the path as necessary

date_default_timezone_set('Asia/Makassar');

$servername = 'localhost';
$username = 'mindimedia_admin';
$password = '7rdcCQX2DDHt';
$dbname = 'mindimedia_balitiket';

// Mendapatkan body dari request
$body = file_get_contents("php://input");

// Decode JSON payload
$data = json_decode($body, true);

$secret_key = 'QXudHpFGdEzuVZAIFHtDwn4KDMm2ibuILpxh06x4BC2JXu0G'; // Dapatkan dari dashboard Xendit
$x_signature = isset($_SERVER['HTTP_X_CALLBACK_SIGNATURE']) ? $_SERVER['HTTP_X_CALLBACK_SIGNATURE'] : '';
$calculated_signature = hash_hmac('sha256', $body, $secret_key);

if (isset($data['status']) && $data['status'] == 'PAID') {
    // Invoice telah dibayar
    $external_id = $data['external_id'];

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        http_response_code(500);
        exit('Database connection error');
    }

    $stmt = $conn->prepare("UPDATE yuren_balitiket_bookings SET status_payment='paid' WHERE no_invoice=?");
    $stmt->bind_param("s", $external_id);

    if ($stmt->execute()) {

        $sql = "SELECT * FROM yuren_balitiket_bookings WHERE no_invoice = '".$external_id."'";
        $result = $conn->query($sql);
        $booking = $result->fetch_assoc();

            // data booking
        $date1 = date('d/m/Y');
        $arrival_date = date('d/m/Y', strtotime($booking['arrival_date']));

        $adult_summary = '';
        if ($booking['adult'] != 0){
            $adult_price = number_format((int)$booking['total_adult_price'],0,',','.');
            $adult_summary = '<tr>
            <td style="width:calc(100%/3); padding: 0 0 7px 0">Adult</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align: center">'.$booking['adult'].'</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align:right">IDR '.$adult_price.'</td>
            </tr>';
        }

        $children_summary = '';
        if ($booking['children'] != 0){
            $children_price = number_format((int)$booking['total_children_price'],0,',','.');
            $children_summary = '<tr>
            <td style="width:calc(100%/3); padding: 0 0 7px 0">Adult</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align: center">'.$booking['children'].'</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align:right">IDR '.$children_price.'</td>
            </tr>';
        }

        $infant_summary = '';
        if ($booking['infant'] != 0){
            $infant_price = number_format((int)$booking['total_infant_price'],0,',','.');
            $infant_summary = '<tr>
            <td style="width:calc(100%/3); padding: 0 0 7px 0">Adult</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align: center">'.$booking['infant'].'</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; text-align:right">IDR '.$infant_price.'</td>
            </tr>';
        }

        // get inclusion ticket
        $sqlticket = 'SELECT * FROM yuren_balitiket_tickets WHERE id = '.$booking['ticket_id'];
        $resultinclusion = $conn->query($sqlticket);
        $resultticket = $conn->query($sqlticket);
        $ticket = $resultticket->fetch_assoc();

        $inclusion_items = [];
        if ($resultinclusion->num_rows > 0) {
            while($row = $resultinclusion->fetch_assoc()) {
                $inclusion_json = $row['inclusion'];
                $inclusion_items = json_decode($inclusion_json, true);
            }
        }

        $inclusions = '';
        if (!empty($inclusion_items)) {
            foreach ($inclusion_items as $inclusion) {
                $inclusions .= '<li style="margin: 0 0 7px 0">' . htmlspecialchars($inclusion['item']) . '</li>';
            }
        }
        // end get inclusion ticket

        // vendor opening hours
        $sqlvendor = 'SELECT * FROM yuren_balitiket_vendors WHERE id = '.$booking['vendor_id'];
        $resultvendor = $conn->query($sqlvendor);
        $vendors = $resultvendor->fetch_assoc();
        $vendor = json_decode($vendors['schedule'], true);
        $start_time = date('H:i', strtotime($vendor[0]['start_time']));
        $end_time = date('H:i', strtotime($vendor[0]['end_time']));

        $opening_hour = $start_time.' - '.$end_time;
        // end vendor opening hours


        $total_price = number_format((int)$booking['total_price'],0,',','.');
        // end data booking


        // img stored
        // logo
        $pathlogo = 'img/logo.png';
        $datalogo = base64_encode(file_get_contents($pathlogo));
        $logosrc = 'data:image/png;base64,' . $datalogo;

        // envelope1
        $pathenvelope1 = 'img/envelope1.png';
        $dataenvelope1 = base64_encode(file_get_contents($pathenvelope1));
        $envelope1src = 'data:image/png;base64,' . $dataenvelope1;

        // globe1
        $pathglobe1 = 'img/globe1.png';
        $dataglobe1 = base64_encode(file_get_contents($pathglobe1));
        $globe1src = 'data:image/png;base64,' . $dataglobe1;

        // phone1
        $pathphone1 = 'img/phone1.png';
        $dataphone1 = base64_encode(file_get_contents($pathphone1));
        $phone1src = 'data:image/png;base64,' . $dataphone1;

        // barcode1
        $pathbarcode1 = 'img/barcode1.png';
        $databarcode1 = base64_encode(file_get_contents($pathbarcode1));
        $barcode1src = 'data:image/png;base64,' . $databarcode1;

        // barcode2
        $pathbarcode2 = 'img/barcode2.png';
        $databarcode2 = base64_encode(file_get_contents($pathbarcode2));
        $barcode2src = 'data:image/png;base64,' . $databarcode2;

        // ticket1
        $pathticket1 = 'img/ticket1.png';
        $dataticket1 = base64_encode(file_get_contents($pathticket1));
        $ticket1src = 'data:image/png;base64,' . $dataticket1;

        // calendar
        $pathcalendar = 'img/calendar.png';
        $datacalendar = base64_encode(file_get_contents($pathcalendar));
        $calendarsrc = 'data:image/png;base64,' . $datacalendar;

        // lockkey
        $pathlockkey = 'img/lock-key.png';
        $datalockkey = base64_encode(file_get_contents($pathlockkey));
        $lockkeysrc = 'data:image/png;base64,' . $datalockkey;

        // clock
        $pathclock = 'img/clock.png';
        $dataclock = base64_encode(file_get_contents($pathclock));
        $clocksrc = 'data:image/png;base64,' . $dataclock;

        // shield
        $pathshield = 'img/shield.png';
        $datashield = base64_encode(file_get_contents($pathshield));
        $shieldsrc = 'data:image/png;base64,' . $datashield;

        // bgfooter
        $pathbgfooter = 'img/bg-footer.png';
        $databgfooter = base64_encode(file_get_contents($pathbgfooter));
        $bgfootersrc = 'data:image/png;base64,' . $databgfooter;

        // whatsapp
        $pathwhatsapp = 'img/whatsapp.png';
        $datawhatsapp = base64_encode(file_get_contents($pathwhatsapp));
        $whatsappsrc = 'data:image/png;base64,' . $datawhatsapp;

        // envelope2
        $pathenvelope2 = 'img/envelope2.png';
        $dataenvelope2 = base64_encode(file_get_contents($pathenvelope2));
        $envelope2src = 'data:image/png;base64,' . $dataenvelope2;

        // phone2
        $pathphone2 = 'img/phone2.png';
        $dataphone2 = base64_encode(file_get_contents($pathphone2));
        $phone2src = 'data:image/png;base64,' . $dataphone2;
        // end img stored

        // booking voucher
        $voucher = 
        '<div style="background-color: #0A2A48; padding: 2rem; font-family: sans-serif;">
            <div style="width: 750px; margin: 0 auto; background-color: white;">
            <div style="padding: 1rem 1.5rem">

            <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

            <table style="width: 100%; font-size: 10px;">
            <tbody>
            <tr>
            <td style="width: 10%;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/logo.png" style="width:100%">
            </td>
            <td style="width: 80%;">
            <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
            <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            <p align="center" style="margin: 0;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/envelope1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">info@baliticketservice.com</span>
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/globe1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">baliticketservice.com</span>
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/phone1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">(+62) 888 8888 8888</span>
            </p>
            </td>
            <td style="width: 10%;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/barcode1.png" style="width:100%">
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 20px 0 7px 0; font-size: 14px;">Booking Details</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px;">
            <tbody>
            <tr>
            <td style="width: 45%; padding: 1rem; border-right: 1px dashed #008AC6;">
            <table style="font-size: 11px; width: 100%;">   
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Name</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['name'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Phone</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['phone'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Email</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['email'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Country</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['country'].'</td>
            </tr>
            <tr>
            <td style="width:100%; padding: 0 0 7px 0; text-align: center" colspan="2">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/barcode2.png" style="width:40%">
            </td>
            </tr>
            <tr>
            <td style="width:100%; padding: 0; font-size: 13px ;text-align: center" colspan="2">
            <b>BOOKING ID : '.$booking['no_invoice'].'</b>
            </td>
            </tr>
            </table>
            </td>
            <td style="width: 55%; padding: 0; vertical-align: baseline;">
            <p style="margin: 0; padding: 1rem; background-color: #ECF9FF; border-radius: 0 18px 0 0; font-weight: bold">
            <span style="font-size: 14px;">TICKET DETAILS</span>
            <span style="float: right; color: #008AC6; font-size: 12px">Entry Date : '.$arrival_date.'</span>
            </p>
            <table style="font-size: 11px; width: 100%; padding: 1rem"> 
            <tr>
            <td style="width:100%; padding: 0 0 10px 0; font-size: 15px" colspan="3">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/ticket1.png" style="width:18px; vertical-align: bottom">
            <b>Bali Zoo General Admission Ticket</b>
            </td>
            </tr>
            <tr>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold">Category</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold; text-align: center">Amount</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold; text-align:right">Price</td>
            </tr>'
            .$adult_summary. 
            $children_summary. 
            $infant_summary.
            '<tr>
            <td colspan="3"><hr></td>
            </tr>
            <tr>
            <td style="width:calc(2/3*100%); padding: 0 0 7px 0; text-align: right;" colspan="2">
            <b>Total price</b><br>
            <span style="font-size:8px">(Tax Include)</span>
            </td>
            <td style="width:calc(1/3*100%); padding: 0 0 7px 0; text-align:right;"><b>IDR '.$total_price.'</b></td>
            </tr>
            </table>
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF">
            <tbody>
            <tr>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/calendar.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/lock-key.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/clock.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/shield.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
            </td>
            </tr>
            </tbody>
            </table>

            <table style="width: 100%; margin: 30px 0 50px 0; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 40%">
            <p style="margin: 0 0 7px 0"><b>Ticket entry date : </b>'.$arrival_date.'</p>
            <p style="margin: 0 0 7px 0"><b>Zoo opening hours : </b>'.$opening_hour.'</p>
            <p style="margin: 0 0 4px 0"><b>Ticket inclusions : </b></p>
            <ul style="padding: 0 0 0 1rem; margin: 7px 0 0 0;">
            '.$inclusions.'
            </ul>
            </td>
            <td style="width: 60%; vertical-align: baseline;">
            <p style="margin: 0 0 7px 0"><b>Terms & Conditions : </b></p>
            '.$ticket['terms'].'
            </td>
            </tr>
            </tbody>
            </table>

            </div>
            <div style="padding: 1rem 1.5rem; background-image: url(https://balitiket.mindimedia.com/bali_tiket/img/bg-footer.png); background-size: cover; background-position: center;">
            <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
            <tbody>
            <tr>
            <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
            <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            </td>
            <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/phone2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/whatsapp.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0;">
            <img src="https://balitiket.mindimedia.com/bali_tiket/img/envelope2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            test@mail.com
            </p>
            </td>
            <td style="width: 25%; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
            <p style="font-size: 9px; margin: 0;">Https://balitiket.mindimedia.com</p>
            </td>
            </tr>
            </tbody>
            </table>
            </div>
            </div>
            </div>';

        $voucher2 = 
        '
            <!DOCTYPE html>
            <html>
            <head>
            <title>Voucher</title>
            </head>
            <body>
            <div style="padding: 1rem 1.5rem; font-family: sans-serif;">

            <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

            <table style="width: 100%; font-size: 10px;">
            <tbody>
            <tr>
            <td style="width: 10%;">
            <img src="'.$logosrc.'" style="width:100%">
            </td>
            <td style="width: 80%;">
            <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
            <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            <p align="center" style="margin: 0;">
            <img src="'.$envelope1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">info@baliticketservice.com</span>
            <img src="'.$globe1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">baliticketservice.com</span>
            <img src="'.$phone1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">(+62) 888 8888 8888</span>
            </p>
            </td>
            <td style="width: 10%;">
            <img src="'.$barcode1src.'" style="width:100%">
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 20px 0 7px 0; font-size: 14px;">Booking Details</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px;">
            <tbody>
            <tr>
            <td style="width: 45%; padding: 1rem; border-right: 1px dashed #008AC6;">
            <table style="font-size: 11px; width: 100%;">   
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Name</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['name'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Phone</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['phone'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Email</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['email'].'</td>
            </tr>
            <tr>
            <td style="width:30%; padding: 0 0 7px 0; font-weight:bold">Country</td>
            <td style="width:70%; padding: 0 0 7px 0">: &ensp; '.$booking['country'].'</td>
            </tr>
            <tr>
            <td style="width:100%; padding: 0 0 7px 0; text-align: center" colspan="2">
            <img src="'.$barcode2src.'" style="width:40%">
            </td>
            </tr>
            <tr>
            <td style="width:100%; padding: 0; font-size: 13px ;text-align: center" colspan="2">
            <b>BOOKING ID : '.$booking['no_invoice'].'</b>
            </td>
            </tr>
            </table>
            </td>
            <td style="width: 55%; padding: 0; vertical-align: baseline;">
            <p style="margin: 0; padding: 1rem; background-color: #ECF9FF; border-radius: 0 18px 0 0; font-weight: bold">
            <span style="font-size: 14px;">TICKET DETAILS</span>
            <span style="float: right; color: #008AC6; font-size: 12px">Entry Date : '.$arrival_date.'</span>
            </p>
            <table style="font-size: 11px; width: 100%; padding: 1rem"> 
            <tr>
            <td style="width:100%; padding: 0 0 10px 0; font-size: 15px" colspan="3">
            <img src="'.$ticket1src.'" style="width:18px; vertical-align: bottom">
            <b>Bali Zoo General Admission Ticket</b>
            </td>
            </tr>
            <tr>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold">Category</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold; text-align: center">Amount</td>
            <td style="width:calc(100%/3); padding: 0 0 7px 0; font-weight:bold; text-align:right">Price</td>
            </tr>'
            .$adult_summary. 
            $children_summary. 
            $infant_summary.
            '<tr>
            <td colspan="3"><hr></td>
            </tr>
            <tr>
            <td style="width:calc(2/3*100%); padding: 0 0 7px 0; text-align: right;" colspan="2">
            <b>Total price</b><br>
            <span style="font-size:8px">(Tax Include)</span>
            </td>
            <td style="width:calc(1/3*100%); padding: 0 0 7px 0; text-align:right;"><b>IDR '.$total_price.'</b></td>
            </tr>
            </table>
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF">
            <tbody>
            <tr>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$calendarsrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$lockkeysrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$clocksrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$shieldsrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
            </td>
            </tr>
            </tbody>
            </table>

            <table style="width: 100%; margin: 30px 0 50px 0; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 40%">
            <p style="margin: 0 0 7px 0"><b>Ticket entry date : </b>'.$arrival_date.'</p>
            <p style="margin: 0 0 7px 0"><b>Zoo opening hours : </b>'.$opening_hour.'</p>
            <p style="margin: 0 0 4px 0"><b>Ticket inclusions : </b></p>
            <ul style="padding: 0 0 0 1rem; margin: 7px 0 0 0;">
            '.$inclusions.'
            </ul>
            </td>
            <td style="width: 60%; vertical-align: baseline;">
            <p style="margin: 0 0 7px 0"><b>Terms & Conditions : </b></p>
            '.$ticket['terms'].'
            </td>
            </tr>
            </tbody>
            </table>

            </div>
            <div style="padding: 1rem 1.5rem; background-image: url('.$bgfootersrc.'); background-size: cover; background-position: center;">
            <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
            <tbody>
            <tr>
            <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
            <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            </td>
            <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="'.$phone2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="'.$whatsappsrc.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0;">
            <img src="'.$envelope2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            test@mail.com
            </p>
            </td>
            <td style="width: 25%; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
            <p style="font-size: 9px; margin: 0;">Https://balitiket.mindimedia.com</p>
            </td>
            </tr>
            </tbody>
            </table>
            </div>
            </body>
            </html>';

        // Generate PDF from HTML content
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true); // Enable HTML5 parsing
        $options->set('isPhpEnabled', true); // Enable PHP script rendering

        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($voucher2);

        // Set paper size and orientation (optional)
        $dompdf->setPaper('A4', 'portrait');

        // Render PDF (optional)
        $dompdf->render();

        // Save PDF file
        $pdfFilePath = 'voucher/' . $booking['no_invoice'] . '.pdf';
        file_put_contents($pdfFilePath, $dompdf->output());

        // Update database with PDF file path
        $stmtUpdate = $conn->prepare("UPDATE yuren_balitiket_bookings SET voucher_link=? WHERE no_invoice=?");
        $stmtUpdate->bind_param("ss", $pdfFilePath, $external_id);
        $stmtUpdate->execute();
        // end booking voucher

        // send voucher
        try {
            $mail = new PHPMailer(true);

            //Server settings
            $mail->SMTPDebug = 0;  
            $mail->Host       = 'mail.mindimedia.com';                 
            $mail->SMTPAuth   = true;                                
            $mail->Username   = 'rendi@mindimedia.com';        
            $mail->Password   = 'RendiMindi2023';                            
            $mail->SMTPSecure = 'ssl';       
            $mail->Port       = 465;

            //pengirim
            $mail->setFrom('rendi@mindimedia.com');
            $mail->addAddress($booking['email']);

            //Content
            $mail->isHTML(true);
            $mail->Subject = 'Ticket - '.$booking['no_invoice'];
            $mail->Body    = $voucher;

            $mail->addAttachment($pdfFilePath);

            $mail->AltBody = '';
            $mail->send();

        } catch (Exception $e){

        } 
        // end send voucher


    } else {
        file_put_contents('xendit-webhook.log', "Query error: " . $stmt->error . "\n", FILE_APPEND);
        http_response_code(500);
        exit('Database query error');
    }

    $stmt->close();
    $conn->close();
} else {
    file_put_contents('xendit-webhook.log', "Invalid status\n", FILE_APPEND);
    http_response_code(400);
    exit('Invalid status');
}

// Response ke Xendit bahwa webhook telah diterima dan diproses
http_response_code(200);
echo 'Webhook received';
?>
